// Para1.cpp : implementation file
//

#include "stdafx.h"
#include "3D Printer.h"
#include "3D PrinterDlg.h"

#include "typedef.h"
#include "Delay.h"
#include "Command.h"
#include <math.h>
#include "usbprint.h"

static CPara1* pDlg=NULL;
extern unsigned char CheckDevice(void);
extern volatile   BOOL UsbConnect;
extern double Hour;
extern volatile BOOL bDeviceChange;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPara1 dialog


CPara1::CPara1(CWnd* pParent /*=NULL*/)
	: CDialog(CPara1::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPara1)
	m_LedValue = 0;
	m_LedExpoTime =1000;
	//}}AFX_DATA_INIT
}


void CPara1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPara1)
	DDX_Control(pDX, IDC_DEVICE_INDEX, m_DeviceIndex);
	DDX_Control(pDX, IDC_LED_INDEX, m_LedIndex);
	DDX_Control(pDX, IDC_EDIT_LED, m_Edit_Led);
	DDX_Control(pDX, IDC_SLIDER_LED, m_Slider_Led);
	DDX_Text(pDX, IDC_EDIT_LED, m_LedValue);
	DDV_MinMaxUInt(pDX, m_LedValue, 0, 100);
	DDX_Text(pDX, IDC_EDIT_EXPOTIME, m_LedExpoTime);
	DDV_MinMaxUInt(pDX, m_LedExpoTime, 0, 99999);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPara1, CDialog)
	//{{AFX_MSG_MAP(CPara1)
	ON_BN_CLICKED(IDC_LED_CTRL, OnLedCtrl)
	ON_BN_CLICKED(IDC_BUTTON_LED_SET, OnButtonLedSet)
	ON_BN_CLICKED(IDC_BUTTON_LED_GET, OnButtonLedGet)
	ON_EN_CHANGE(IDC_EDIT_LED, OnChangeEditLed)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_LED, OnCustomdrawSliderLed)
	ON_BN_CLICKED(IDC_POWER_CTRL, OnPowerCtrl)
	ON_CBN_SELCHANGE(IDC_DEVICE_INDEX, OnSelchangeDeviceIndex)
	ON_BN_CLICKED(IDC_POWER_CTRL2, OnPowerCtrl2)
	ON_BN_CLICKED(IDC_POWER_CTRL3, OnPowerCtrl3)
	ON_BN_CLICKED(IDC_BUTTON_EXPOSURE, OnButtonExposure)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPara1 message handlers

void CPara1::OnLedCtrl() 
{
	// TODO: Add your control notification handler code here
	HWND   hwnd;
	unsigned char Index;
	//int i=0;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	UpdateData(TRUE);
	Index = m_LedIndex.GetCurSel();
	if(f_LedOff)
	{
		GetDlgItem(IDC_SLIDER_LED,&hwnd);
        ::EnableWindow(hwnd,TRUE);
		GetDlgItem(IDC_EDIT_LED,&hwnd);
        ::EnableWindow(hwnd,TRUE);
		GetDlgItem(IDC_BUTTON_LED_SET,&hwnd);
        ::EnableWindow(hwnd,TRUE);
		GetDlgItem(IDC_BUTTON_LED_GET,&hwnd);
        ::EnableWindow(hwnd,TRUE);
		
		if(LedOnOff(Index,1)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}
			
		f_LedOff=FALSE;
		SetDlgItemText(IDC_LED_CTRL,_CS("Led.Off"));
	}
	else
	{
		GetDlgItem(IDC_SLIDER_LED,&hwnd);
        ::EnableWindow(hwnd,FALSE);
		GetDlgItem(IDC_EDIT_LED,&hwnd);
        ::EnableWindow(hwnd,FALSE);
		GetDlgItem(IDC_BUTTON_LED_SET,&hwnd);
        ::EnableWindow(hwnd,FALSE);
		GetDlgItem(IDC_BUTTON_LED_GET,&hwnd);
        ::EnableWindow(hwnd,FALSE);

		if(LedOnOff(Index,0)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return;
		}

		f_LedOff=TRUE;
		SetDlgItemText(IDC_LED_CTRL,_CS("Led.On"));
	}
}

static BOOL f_first=TRUE;
static BOOL f_DlgFirst=TRUE;


BOOL CPara1::OnInitDialog() 
{
	CDialog::OnInitDialog();
	_CWndCS(this);
	// TODO: Add extra initialization here
	CString gsliderstr,DevIndex;
	//unsigned int i;
	pDlg=this;
	if(f_DlgFirst)
	{
		m_Slider_Led.SetRange(0,100);
		m_Slider_Led.SetTicFreq(1);
		SliderPos=m_Slider_Led.GetPos();
		gsliderstr.Format("%d",m_Slider_Led.GetPos());
		SetDlgItemText(IDC_EDIT_LED,gsliderstr);
		
		UpdateData(FALSE);
		m_LedIndex.SetCurSel(-1);
		m_LedIndex.AddString(" 1 ");
		m_LedIndex.AddString(" 2 ");
		m_LedIndex.SetCurSel(0);
        
		/*
		m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
		   DevIndex.Format(" %d ",i);
           m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_DeviceIndex.AddString(" XXX ");
		m_DeviceIndex.SetCurSel(0);
		*/
		UpdateData(TRUE);
        f_PowerOff=TRUE;
		f_LedOff=FALSE;
		f_DlgFirst=FALSE;
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPara1::OnButtonLedSet() 
{
	// TODO: Add your control notification handler code here
	CString StrVal;
	U8 Value,Index;  
	BOOL flag;
    UpdateData(TRUE);
	if(CheckDevice()==1)
	{
		GetDlgItemText(IDC_EDIT_LED,StrVal);
		Value=atoi((const char*)StrVal);
		m_Slider_Led.SetPos(Value);
		SliderPos=Value;
		Index=m_LedIndex.GetCurSel();
		flag=SetCurrent(Index,Value);
		if(flag==FALSE)
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	}
	else
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	}
}

void CPara1::OnButtonLedGet() 
{
	// TODO: Add your control notification handler code here
	U8 Value=0,Index;
	CString StrVal;
	UpdateData(TRUE);
	if(CheckDevice()==1)
	{
		Index=m_LedIndex.GetCurSel();
		if(GetCurrent(Index,&Value)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}

		if(Value>100)
		{
			MessageBox(_CS("WarningUart.ReadFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}

		StrVal.Format("%d",Value);
		m_Slider_Led.SetPos(Value);
		SliderPos=Value;
		SetDlgItemText(IDC_EDIT_LED,StrVal);
	}
	else
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
}

void CPara1::OnChangeEditLed() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
}

void CPara1::OnCustomdrawSliderLed(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CString setgreenstr;
	U16 SliderPosNew;
	
	UpdateData(TRUE);
	SliderPosNew=m_Slider_Led.GetPos();
	if(SliderPos!=SliderPosNew)
	{
		setgreenstr.Format("%d",SliderPosNew);
		SetDlgItemText(IDC_EDIT_LED,setgreenstr);
		SliderPos=SliderPosNew;
	}
	UpdateData(FALSE);
	*pResult = 0;
}

BOOL CPara1::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
		return TRUE; 
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN) 
		return TRUE;
	if ((pMsg->message==WM_LBUTTONDOWN) && (pMsg->hwnd == m_Edit_Led.m_hWnd ))
	{
		CString g;
		U16 gval;
		//int   iRadioButton;   
		//iRadioButton=GetCheckedRadioButton(IDC_RADIO_R,IDC_RADIO_W); 
		
		
		GetDlgItemText(IDC_EDIT_LED,g);
		gval=atoi((const char *)g);
		if(gval>=0 && gval<=100)
		{
			m_Slider_Led.SetPos(gval);
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}



void CPara1::OnPowerCtrl() 
{
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	// TODO: Add your control notification handler code here
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(f_PowerOff)
	{	
		if(PowerOnOff(1)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}
		
		f_PowerOff=FALSE;
		SetDlgItemText(IDC_POWER_CTRL,_CS("Led.Off"));
		//p->m_StatusBar.SetText(_CS("WarningGeneral.PowerOn"), 1, 0);
	}
	else
	{	
		if(PowerOnOff(0)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return;
		}
		
		f_PowerOff=TRUE;
		SetDlgItemText(IDC_POWER_CTRL,_CS("Led.On"));
		//p->m_StatusBar.SetText(_CS("WarningGeneral.PowerOff"), 1, 0);
	}
}


void CPara1::OnSelchangeDeviceIndex() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	HWND hwndStatusBar=p->m_StatusBar.GetSafeHwnd();
	HWND hwndLedIndex=p->m_para1.m_LedIndex.GetSafeHwnd();
	U32 UseTime;
	CString StrHour;
	CString StrLedDefaultStatus;
	U8 Value=0,Index;
	CString StrVal;
	//unsigned char flag;
	unsigned char ID[8];
	CString StrTxt;
	if(p->m_para5.IspWorking)
	{
       UpdateData(FALSE);
	   return;
	}
	if(bDeviceChange)
		return;
	if(USBDeviceInfo.count==0)
		return;
    UpdateData(TRUE);
	USBDevIndex=m_DeviceIndex.GetCurSel();
	if(CheckUSBOnline()==FALSE)
	{
		StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
		::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		StrTxt="SN: XX-XX-XX-XX-XX-XX";
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		UsbConnect=FALSE;
		return ;
	}
	StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
	::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
	UsbConnect=TRUE;
	//if(strcmp(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0])==0)
	//	return;
	memset(DeviceName,0,MAX_PATH);
	strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
	if(CheckDevice()==1)
	{
		if(GetLedDefaultStatus(&Value))
		{
			if(Value)
				StrLedDefaultStatus=_CS("Led.Off");
			else
				StrLedDefaultStatus=_CS("Led.On");
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
		}
		GetProductID(ID);
		StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		//----------------------------------
		Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
		//Index=m_para1.m_LedIndex.GetCurSel();
		if(GetCurrent(Index,&Value)==FALSE)
			return;	
		if(Value>100)
			return;
		StrVal.Format("%d",Value);
		p->m_para1.m_Slider_Led.SetPos(Value);
		p->m_para1.SliderPos=Value;
		::SetDlgItemText(p->m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
		if(GetUseTime(&UseTime))
		{
			Hour=UseTime/(3600.0f);
			StrHour.Format("%.1f",Hour);
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
		}
	}
}
//POWER ON
void CPara1::OnPowerCtrl2() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	// TODO: Add your control notification handler code here
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	//if(f_PowerOff)
	{	
		if(PowerOnOff(1)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}
		
		f_PowerOff=FALSE;
		SetDlgItemText(IDC_POWER_CTRL,_CS("Led.Off"));
		//p->m_StatusBar.SetText(_CS("WarningGeneral.PowerOn"), 1, 0);
	}
	
}
//POWER OFF
void CPara1::OnPowerCtrl3() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	// TODO: Add your control notification handler code here
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	//if(f_PowerOff)
	{	
		if(PowerOnOff(0)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return;
		}
		
		f_PowerOff=TRUE;
		SetDlgItemText(IDC_POWER_CTRL,_CS("Led.On"));
		//p->m_StatusBar.SetText(_CS("WarningGeneral.PowerOff"), 1, 0);
	}	
}
//LED Exposure
void CPara1::OnButtonExposure() 
{
	// TODO: Add your control notification handler code here
	CString StrVal;
	U16 ExposureValue,
	U8 Index;  
	BOOL flag;	
      Index =0;
	//if(CheckDevice()!=1)
	{
	//	MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	//	return ;
	}
	UpdateData(TRUE);

	//led on
	if(LedOnOff(Index,1)==FALSE)
	{
		//MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		//return ;
	}
	SetDlgItemText(IDC_BUTTON_EXPOSURE,_CS("EXPO Doing"));
	//exposure time
	GetDlgItemText(IDC_EDIT_EXPOTIME,StrVal);
	ExposureValue=atoi((const char*)StrVal);//ascii to integer
      Delay1Ms(ExposureValue);//range =1-65536ms
      //Delay1Ms(3000);

	//led off
	if(LedOnOff(Index,0)==FALSE)
	{
		//MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		//return ;
	}
	SetDlgItemText(IDC_BUTTON_EXPOSURE,_CS("EXPOSUTE"));



}
